/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FieldInvertState;
import org.apache.lucene.ars_nouveau.index.IndexOptions;
import org.apache.lucene.ars_nouveau.index.IndexableField;
import org.apache.lucene.ars_nouveau.index.ParallelPostingsArray;
import org.apache.lucene.ars_nouveau.index.TermsHash;
import org.apache.lucene.ars_nouveau.index.TermsHashPerField;
import org.apache.lucene.ars_nouveau.util.BytesRef;

final class FreqProxTermsWriterPerField
extends TermsHashPerField {
    private FreqProxPostingsArray freqProxPostingsArray;
    private final FieldInvertState fieldState;
    private final FieldInfo fieldInfo;
    final boolean hasFreq;
    final boolean hasProx;
    final boolean hasOffsets;
    PayloadAttribute payloadAttribute;
    OffsetAttribute offsetAttribute;
    TermFrequencyAttribute termFreqAtt;
    boolean sawPayloads;

    FreqProxTermsWriterPerField(FieldInvertState invertState, TermsHash termsHash, FieldInfo fieldInfo, TermsHashPerField nextPerField) {
        super(fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 ? 2 : 1, termsHash.intPool, termsHash.bytePool, termsHash.termBytePool, termsHash.bytesUsed, nextPerField, fieldInfo.name, fieldInfo.getIndexOptions());
        this.fieldState = invertState;
        this.fieldInfo = fieldInfo;
        this.hasFreq = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        this.hasProx = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.hasOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    void finish() throws IOException {
        super.finish();
        if (this.sawPayloads) {
            this.fieldInfo.setStorePayloads();
        }
    }

    @Override
    boolean start(IndexableField f, boolean first) {
        super.start(f, first);
        this.termFreqAtt = this.fieldState.termFreqAttribute;
        this.payloadAttribute = this.fieldState.payloadAttribute;
        this.offsetAttribute = this.fieldState.offsetAttribute;
        return true;
    }

    void writeProx(int termID, int proxCode) {
        if (this.payloadAttribute == null) {
            this.writeVInt(1, proxCode << 1);
        } else {
            BytesRef payload = this.payloadAttribute.getPayload();
            if (payload != null && payload.length > 0) {
                this.writeVInt(1, proxCode << 1 | 1);
                this.writeVInt(1, payload.length);
                this.writeBytes(1, payload.bytes, payload.offset, payload.length);
                this.sawPayloads = true;
            } else {
                this.writeVInt(1, proxCode << 1);
            }
        }
        assert (this.postingsArray == this.freqProxPostingsArray);
        this.freqProxPostingsArray.lastPositions[termID] = this.fieldState.position;
    }

    void writeOffsets(int termID, int offsetAccum) {
        int startOffset = offsetAccum + this.offsetAttribute.startOffset();
        int endOffset = offsetAccum + this.offsetAttribute.endOffset();
        assert (startOffset - this.freqProxPostingsArray.lastOffsets[termID] >= 0);
        this.writeVInt(1, startOffset - this.freqProxPostingsArray.lastOffsets[termID]);
        this.writeVInt(1, endOffset - startOffset);
        this.freqProxPostingsArray.lastOffsets[termID] = startOffset;
    }

    @Override
    void newTerm(int termID, int docID) {
        FreqProxPostingsArray postings = this.freqProxPostingsArray;
        postings.lastDocIDs[termID] = docID;
        if (!this.hasFreq) {
            assert (postings.termFreqs == null);
            postings.lastDocCodes[termID] = docID;
            this.fieldState.maxTermFrequency = Math.max(1, this.fieldState.maxTermFrequency);
        } else {
            postings.lastDocCodes[termID] = docID << 1;
            postings.termFreqs[termID] = this.getTermFreq();
            if (this.hasProx) {
                this.writeProx(termID, this.fieldState.position);
                if (this.hasOffsets) {
                    this.writeOffsets(termID, this.fieldState.offset);
                }
            } else assert (!this.hasOffsets);
            this.fieldState.maxTermFrequency = Math.max(postings.termFreqs[termID], this.fieldState.maxTermFrequency);
        }
        ++this.fieldState.uniqueTermCount;
    }

    @Override
    void addTerm(int termID, int docID) {
        FreqProxPostingsArray postings = this.freqProxPostingsArray;
        assert (!this.hasFreq || postings.termFreqs[termID] > 0);
        if (!this.hasFreq) {
            assert (postings.termFreqs == null);
            if (this.termFreqAtt != null && this.termFreqAtt.getTermFrequency() != 1) {
                throw new IllegalStateException("field \"" + this.getFieldName() + "\": must index term freq while using custom TermFrequencyAttribute");
            }
            if (docID != postings.lastDocIDs[termID]) {
                assert (docID > postings.lastDocIDs[termID]);
                this.writeVInt(0, postings.lastDocCodes[termID]);
                postings.lastDocCodes[termID] = docID - postings.lastDocIDs[termID];
                postings.lastDocIDs[termID] = docID;
                ++this.fieldState.uniqueTermCount;
            }
        } else if (docID != postings.lastDocIDs[termID]) {
            assert (docID > postings.lastDocIDs[termID]) : "id: " + docID + " postings ID: " + postings.lastDocIDs[termID] + " termID: " + termID;
            if (1 == postings.termFreqs[termID]) {
                this.writeVInt(0, postings.lastDocCodes[termID] | 1);
            } else {
                this.writeVInt(0, postings.lastDocCodes[termID]);
                this.writeVInt(0, postings.termFreqs[termID]);
            }
            postings.termFreqs[termID] = this.getTermFreq();
            this.fieldState.maxTermFrequency = Math.max(postings.termFreqs[termID], this.fieldState.maxTermFrequency);
            postings.lastDocCodes[termID] = docID - postings.lastDocIDs[termID] << 1;
            postings.lastDocIDs[termID] = docID;
            if (this.hasProx) {
                this.writeProx(termID, this.fieldState.position);
                if (this.hasOffsets) {
                    postings.lastOffsets[termID] = 0;
                    this.writeOffsets(termID, this.fieldState.offset);
                }
            } else assert (!this.hasOffsets);
            ++this.fieldState.uniqueTermCount;
        } else {
            postings.termFreqs[termID] = Math.addExact(postings.termFreqs[termID], this.getTermFreq());
            this.fieldState.maxTermFrequency = Math.max(this.fieldState.maxTermFrequency, postings.termFreqs[termID]);
            if (this.hasProx) {
                this.writeProx(termID, this.fieldState.position - postings.lastPositions[termID]);
                if (this.hasOffsets) {
                    this.writeOffsets(termID, this.fieldState.offset);
                }
            }
        }
    }

    private int getTermFreq() {
        int freq;
        int n = freq = this.termFreqAtt == null ? 1 : this.termFreqAtt.getTermFrequency();
        if (freq != 1 && this.hasProx) {
            throw new IllegalStateException("field \"" + this.getFieldName() + "\": cannot index positions while using custom TermFrequencyAttribute");
        }
        return freq;
    }

    @Override
    public void newPostingsArray() {
        this.freqProxPostingsArray = (FreqProxPostingsArray)this.postingsArray;
    }

    @Override
    ParallelPostingsArray createPostingsArray(int size) {
        boolean hasFreq = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean hasProx = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean hasOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        return new FreqProxPostingsArray(size, hasFreq, hasProx, hasOffsets);
    }

    static final class FreqProxPostingsArray
    extends ParallelPostingsArray {
        int[] termFreqs;
        int[] lastDocIDs;
        int[] lastDocCodes;
        int[] lastPositions;
        int[] lastOffsets;

        public FreqProxPostingsArray(int size, boolean writeFreqs, boolean writeProx, boolean writeOffsets) {
            super(size);
            if (writeFreqs) {
                this.termFreqs = new int[size];
            }
            this.lastDocIDs = new int[size];
            this.lastDocCodes = new int[size];
            if (writeProx) {
                this.lastPositions = new int[size];
                if (writeOffsets) {
                    this.lastOffsets = new int[size];
                }
            } else assert (!writeOffsets);
        }

        @Override
        ParallelPostingsArray newInstance(int size) {
            return new FreqProxPostingsArray(size, this.termFreqs != null, this.lastPositions != null, this.lastOffsets != null);
        }

        @Override
        void copyTo(ParallelPostingsArray toArray, int numToCopy) {
            assert (toArray instanceof FreqProxPostingsArray);
            FreqProxPostingsArray to = (FreqProxPostingsArray)toArray;
            super.copyTo(toArray, numToCopy);
            System.arraycopy(this.lastDocIDs, 0, to.lastDocIDs, 0, numToCopy);
            System.arraycopy(this.lastDocCodes, 0, to.lastDocCodes, 0, numToCopy);
            if (this.lastPositions != null) {
                assert (to.lastPositions != null);
                System.arraycopy(this.lastPositions, 0, to.lastPositions, 0, numToCopy);
            }
            if (this.lastOffsets != null) {
                assert (to.lastOffsets != null);
                System.arraycopy(this.lastOffsets, 0, to.lastOffsets, 0, numToCopy);
            }
            if (this.termFreqs != null) {
                assert (to.termFreqs != null);
                System.arraycopy(this.termFreqs, 0, to.termFreqs, 0, numToCopy);
            }
        }

        @Override
        int bytesPerPosting() {
            int bytes = 20;
            if (this.lastPositions != null) {
                bytes += 4;
            }
            if (this.lastOffsets != null) {
                bytes += 4;
            }
            if (this.termFreqs != null) {
                bytes += 4;
            }
            return bytes;
        }
    }
}

